//////////////////////////////////////////////////////
// File: "CGame.h"
// Author: Alyssa Dettling (AD)
// Purpose: This file will contain all game functionality
//////////////////////////////////////////////////////

#pragma once

#include "CSGD_Direct3D.h"
#include "CSGD_TextureManager.h"
#include "CSGD_FModManager.h"
#include "CSGD_DirectInput.h"
#include "CBitmapFontManager.h"
#include <windows.h>
#include <string>
#include <vector>
#include "IGameState.h"
#include "AnimationManager.h"

class wiimote;

using std::vector;

class CGame
{
private:
	//	Pointers to SGD Wrappers:
	CSGD_Direct3D*			m_pD3D;
	CSGD_TextureManager*	m_pTM;
	CSGD_DirectInput*		m_pDI;
	CSGD_FModManager*		m_pFM;
	CBitmapFontManager*		m_pBM;
	CAnimationManager*		m_pAM;

	int m_nWidth;
	int m_nHeight;

	HWND m_hWnd;

	vector<IGameState*>		m_vCurStates;
	IGameState*				m_pCurState;

	//Between 0.0 and 1.0f
	float m_fSoundVolume;
	float m_fSongVolume;

	bool m_bIsWindowed;

	//Between -1.0 and 1.0
	float m_fPan;

	//	Proper singleton:
	CGame(void);
	CGame(const CGame&);
	CGame& operator=(const CGame&);
	~CGame(void);

	public:
	
	///////////////////////////////////////////////////////
	//	Function : GetInstance
	//	Last Modified: July 21, 2008
	//	Purpose: This will get the only instance 
	//	of this class and return it to the calling object.
	///////////////////////////////////////////////////////
	static CGame* GetInstance(void);

	///////////////////////////////////////////////////////
	//	Function : Initialize
	//	Last Modified: July 21, 2008
	//	Purpose: This will initialize any and all items that
	//		the class needs
	///////////////////////////////////////////////////////
	bool Initialize(HWND hWnd, HINSTANCE hInstance,
					   int nScreenWidth, int nScreenHeight, bool bIsWindowed);
	
	///////////////////////////////////////////////////////
	//	Function : Main
	//	Last Modified: July 21, 2008
	//	Purpose: This will execute any functions needed by 
	//		the game to run.
	///////////////////////////////////////////////////////
	bool Update(void);

	///////////////////////////////////////////////////////
	//	Function : Shutdown
	//	Last Modified: July 21, 2008
	//	Purpose: This will clean up any and all code and pointers.
	///////////////////////////////////////////////////////
	void Shutdown(void);

	///////////////////////////////////////////////////////
	//	Function : AddState
	//	Last Modified: July 21, 2008
	//	Purpose: This will add a state to the stack
	///////////////////////////////////////////////////////
	void AddState(IGameState* pNewState);

	///////////////////////////////////////////////////////
	//	Function : RemoveState
	//	Last Modified: July 21, 2008
	//	Purpose: This will remove the topmost state from the stack
	///////////////////////////////////////////////////////
	void RemoveState();

	///////////////////////////////////////////////////////
	//	Function : RemoveAllStates
	//	Last Modified: July 21, 2008
	//	Purpose: This will remove all states from the stack
	///////////////////////////////////////////////////////
	void RemoveAllStates();


	///////////////////////////////////
	//	Function : Accessors 
	//	Last Modified: July 21, 2008
	//	Purpose : Returns the specified type
	////////////////////////////////////
	inline float GetSoundVolume() {return m_fSoundVolume;}
	inline float GetSongVolume() {return m_fSongVolume;}
	inline float GetPan() {return m_fPan;}
	inline int GetWidth() { return m_nWidth;}
	inline int GetHeight() {return m_nHeight;}
	inline vector<IGameState*> GetCurrStates() {return m_vCurStates;}

	///////////////////////////////////
	//	Function : Modifiers
	//	Last Modified: July 21, 2008
	//  Purpose : Modifies the specified type
	///////////////////////////////////
	inline void SetSoundVolume(float nVolume) {m_fSoundVolume = nVolume;}
	inline void SetSongVolume(float nVolume) {m_fSongVolume = nVolume;}
	inline void SetPan(float nPan) {m_fPan = nPan;}
};